unit _ulamek;

interface

uses SysUtils;

type
Ulamek_Exception = class(Exception)
    private
        Message :String;
    public
        constructor Create(const AMessage :String);
        function What :String;
    end;

Ulamek = class
    private
        licznik :Integer;
        mianownik :Integer;
    public
        constructor Create(const alicznik :Integer =0; const amianownik :Integer =1);
        procedure SetValues(const alicznik, amianownik :Integer);
        procedure GetValues(var rlicznik :Integer; var rmianownik :Integer); overload;
        procedure GetValues(plicznik, pmianownik :PInteger); overload;
    end;

function IntToUlamek(const liczba :Integer) :Ulamek;

implementation

constructor Ulamek_Exception.Create(const AMessage :String);
begin
Message:=AMessage;
end;

function Ulamek_Exception.What :String;
begin
What:=Message;
end;


constructor Ulamek.Create(const alicznik :Integer =0; const amianownik :Integer =1);
begin
inherited Create; //TObject.Create()
SetValues(alicznik,amianownik);
end;

procedure Ulamek.SetValues(const alicznik, amianownik :Integer);
begin
if amianownik=0 then raise Ulamek_Exception.Create('Ulamek: Blad #1');
licznik:=alicznik;
mianownik:=amianownik;
end;

procedure Ulamek.GetValues(var rlicznik :Integer; var rmianownik :Integer);
begin
rlicznik:=licznik;
rmianownik:=mianownik;
end;

procedure Ulamek.GetValues(plicznik :PInteger; pmianownik :PInteger);
begin
plicznik^:=licznik;
pmianownik^:=mianownik;
end;


{ FUNKCJA KONWERTUJACA }

function IntToUlamek(const liczba :Integer) :Ulamek;
begin
IntToUlamek:=Ulamek.Create(liczba,1);
end;

end.
